<?php

// API Endpoints Router
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With');

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Basic routing based on URI
$requestUri = $_SERVER['REQUEST_URI'];
$path = parse_url($requestUri, PHP_URL_PATH);
$pathSegments = explode('/', trim($path, '/'));

// Remove any directory prefix to get the endpoint
$endpoint = end($pathSegments);

// Remove .php extension if present
$endpoint = str_replace('.php', '', $endpoint);

try {
    switch ($endpoint) {
        // User endpoints
        case 'get_user':
        case 'get_user_profile':
            require_once __DIR__ . '/api/get_user.php';
            break;

        case 'update_profile':
            require_once __DIR__ . '/api/update_profile.php';
            break;

        case 'update_password':
            require_once __DIR__ . '/api/update_password.php';
            break;

        case 'upload_foto_profil':
            require_once __DIR__ . '/api/upload_foto_profil.php';
            break;

        case 'get_check_phone':
            require_once __DIR__ . '/api/get_check_phone.php';
            break;

        // Auth endpoints
        case 'register':
            require_once __DIR__ . '/api/register.php';
            break;

        case 'get_login':
        case 'login':
            require_once __DIR__ . '/api/get_login.php';
            break;

        case 'get_otp_wa':
            require_once __DIR__ . '/api/get_otp_wa.php';
            break;

        case 'get_login_otp':
            require_once __DIR__ . '/api/get_login_otp.php';
            break;

        case 'send_registration_otp':
            require_once __DIR__ . '/api/send_registration_otp.php';
            break;

        case 'verify_registration_otp':
            require_once __DIR__ . '/api/verify_registration_otp.php';
            break;

        case 'verify_otp':
            require_once __DIR__ . '/api/verify_otp.php';
            break;

        // Banner endpoints
        case 'banner_detail':
            require_once __DIR__ . '/api/banner_detail.php';
            break;

        case 'banner':
            require_once __DIR__ . '/api/banner.php';
            break;

        case 'save_banner_click':
            require_once __DIR__ . '/api/save_banner_click.php';
            break;

        // News endpoints
        case 'news':
            require_once __DIR__ . '/api/news.php';
            break;

        case 'news_detail':
            require_once __DIR__ . '/api/news_detail.php';
            break;

        // FCM endpoints
        case 'save_fcm_token':
        case 'update_fcm_token':
            require_once __DIR__ . '/api/save_fcm_token.php';
            break;

        // Default - API info
        default:
            echo json_encode([
                'success' => true,
                'message' => 'EPasadana API v2.0',
                'timestamp' => date('Y-m-d H:i:s'),
                'endpoints' => [
                    'user' => [
                        'GET /get_user.php?user_id=123',
                        'POST /update_profile.php',
                        'POST /update_password.php',
                        'POST /upload_foto_profil.php',
                        'POST /get_check_phone.php'
                    ],
                    'auth' => [
                        'POST /register.php',
                        'POST /get_login.php',
                        'POST /get_otp_wa.php',
                        'POST /get_login_otp.php',
                        'POST /send_registration_otp.php',
                        'POST /verify_registration_otp.php',
                        'POST /verify_otp.php'
                    ],
                    'banner' => [
                        'GET /banner_detail.php',
                        'GET /banner.php?id=123',
                        'POST /save_banner_click.php'
                    ],
                    'news' => [
                        'GET /news.php',
                        'GET /news_detail.php?id=123'
                    ],
                    'fcm' => [
                        'POST /save_fcm_token.php'
                    ]
                ],
                'architecture' => [
                    'framework' => 'Custom PHP MVC',
                    'database' => 'MySQL with MySQLi',
                    'structure' => [
                        'controllers' => 'Handle business logic and request/response',
                        'models' => 'Database operations and data management',
                        'helpers' => 'Utility classes and services',
                        'config' => 'Database and application configuration'
                    ]
                ]
            ]);
            break;
    }
} catch (Exception $e) {
    error_log("API Router Error: " . $e->getMessage());

    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Internal server error',
        'timestamp' => date('Y-m-d H:i:s')
    ]);
}
